/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Color3f;

public class ColorInterpolator
extends Interpolator {
    Material target;
    Color3f startColor = new Color3f();
    Color3f endColor = new Color3f();
    Color3f newColor = new Color3f();
    private float prevAlphaValue = Float.NaN;
    private int prevColorTarget = -1;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    ColorInterpolator() {
    }

    public ColorInterpolator(Alpha alpha, Material material) {
        super(alpha);
        this.target = material;
        this.startColor.set(0.0f, 0.0f, 0.0f);
        this.endColor.set(1.0f, 1.0f, 1.0f);
    }

    public ColorInterpolator(Alpha alpha, Material material, Color3f color3f, Color3f color3f2) {
        super(alpha);
        this.target = material;
        this.startColor.set(color3f);
        this.endColor.set(color3f2);
    }

    public void setStartColor(Color3f color3f) {
        this.startColor.set(color3f);
        this.prevAlphaValue = Float.NaN;
    }

    public void getStartColor(Color3f color3f) {
        color3f.set(this.startColor);
    }

    public void setEndColor(Color3f color3f) {
        this.endColor.set(color3f);
        this.prevAlphaValue = Float.NaN;
    }

    public void getEndColor(Color3f color3f) {
        color3f.set(this.endColor);
    }

    public void setTarget(Material material) {
        this.target = material;
        this.prevAlphaValue = Float.NaN;
    }

    public Material getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        WakeupCriterion wakeupCriterion = this.passiveWakeupCriterion;
        if (this.alpha != null) {
            float f2 = this.alpha.value();
            int n2 = 2;
            if (this.target.getCapability(0)) {
                n2 = this.target.getColorTarget();
            }
            if (f2 != this.prevAlphaValue || n2 != this.prevColorTarget) {
                this.newColor.x = (1.0f - f2) * this.startColor.x + f2 * this.endColor.x;
                this.newColor.y = (1.0f - f2) * this.startColor.y + f2 * this.endColor.y;
                this.newColor.z = (1.0f - f2) * this.startColor.z + f2 * this.endColor.z;
                switch (n2) {
                    case 0: {
                        this.target.setAmbientColor(this.newColor);
                        break;
                    }
                    case 4: {
                        this.target.setAmbientColor(this.newColor);
                    }
                    case 2: {
                        this.target.setDiffuseColor(this.newColor);
                        break;
                    }
                    case 1: {
                        this.target.setEmissiveColor(this.newColor);
                        break;
                    }
                    case 3: {
                        this.target.setSpecularColor(this.newColor);
                    }
                }
                this.prevAlphaValue = f2;
                this.prevColorTarget = n2;
            }
            if (!this.alpha.finished() && !this.alpha.isPaused()) {
                wakeupCriterion = this.defaultWakeupCriterion;
            }
        }
        this.wakeupOn(wakeupCriterion);
    }

    public Node cloneNode(boolean bl) {
        ColorInterpolator colorInterpolator = new ColorInterpolator();
        colorInterpolator.duplicateNode(this, bl);
        return colorInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        ColorInterpolator colorInterpolator = (ColorInterpolator)node;
        colorInterpolator.getStartColor(this.startColor);
        colorInterpolator.getEndColor(this.endColor);
        this.setTarget(colorInterpolator.getTarget());
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        Material material = this.getTarget();
        if (material != null) {
            this.setTarget((Material)nodeReferenceTable.getNewObjectReference(material));
        }
    }
}

